package FlashReader;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Random;

import doABC.Instruction;
import doABC.InstructionJump;
import doABC.MethodBodyInfo;

public class Encrypter extends SwfTools {
	private ArrayList<MethodBodyInfo> methods;
	private ArrayList<Instruction> instructiondoJump;
	
	
	public Encrypter(ArrayList<MethodBodyInfo> methods){
		this.methods = methods;	
	}
	
	
	
	public void chopAndJump(int blockS, int blockC){
		
		markInstructionToJump();

		for (MethodBodyInfo method:methods){
			
			Random r = new Random();
			
			int blockSize = r.nextInt(blockS)+1;
			
			int blockCount = r.nextInt(blockC)+1;
			
			for (int i =0; i < blockCount;i++){
				int posStart = r.nextInt(method.EN_Instruction.size());
				
				int posEnd = posStart + blockSize;
				
				for (int j =posStart; j < posEnd;j++){
					method.EN_Instruction.get(j);
				}
			}

		}
		
	}
	
	public void  markInstructionToJump(){
		instructiondoJump = new  ArrayList<Instruction>();
		
		for (MethodBodyInfo method:methods){
			instructiondoJump.addAll(getTargets(method));
		}
		
	}

	//Zwraca wszystkie instrukcje w danej metodzie do ktych s skoki: warunkowe, bezwarunkowe itp.
	public ArrayList<Instruction> getTargets(MethodBodyInfo method){
		ArrayList<Instruction> result = new ArrayList<Instruction>();
		
		for (Instruction ins: method.EN_Instruction){
			if( ins.getClass() == InstructionJump.class){
				result.add( ((InstructionJump)ins).toIns );
			}
		}

		return result;
	}
	
	
	
}
